% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomonic.R
\name{gnomonic_fwd}
\alias{gnomonic_fwd}
\alias{gnomonic_rev}
\title{Gnomonic projection}
\usage{
gnomonic_fwd(x, lon0, lat0)

gnomonic_rev(x, y, lon0, lat0)
}
\arguments{
\item{x}{For forward conversion: a two-column matrix or data frame of
coordinates (longitude, latitude) in decimal degrees.
For reverse conversion: numeric vector of x coordinates in meters.}

\item{lon0}{Longitude of the projection center in decimal degrees.}

\item{lat0}{Latitude of the projection center in decimal degrees.}

\item{y}{Numeric vector of y coordinates in meters.}
}
\value{
Data frame with columns:
\itemize{
\item For forward conversion:
\itemize{
\item \code{x}: X coordinate in meters
\item \code{y}: Y coordinate in meters
\item \code{azi}: Azimuth of the geodesic at the center (degrees)
\item \code{rk}: Reciprocal of the azimuthal scale
\item \code{lon}, \code{lat}: Input coordinates (echoed)
}
\item For reverse conversion:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{azi}: Azimuth of the geodesic at the center (degrees)
\item \code{rk}: Reciprocal of the azimuthal scale
\item \code{x}, \code{y}: Input coordinates (echoed)
}
}
}
\description{
Convert between geographic coordinates and the gnomonic projection.
In this projection, geodesics (shortest paths) appear as straight lines,
making it useful for navigation and great circle route planning.
}
\details{
The gnomonic projection has a unique property: all geodesics (great circles
on a sphere, shortest paths on an ellipsoid) appear as straight lines.
This makes it invaluable for:
\itemize{
\item Planning great circle routes in aviation and shipping
\item Seismic ray path analysis
\item Radio wave propagation studies
}

Limitations:
\itemize{
\item Can only show less than a hemisphere
\item Extreme distortion away from the center
\item Neither conformal nor equal-area
}
}
\examples{
# Project cities relative to London
cities <- cbind(
  lon = c(-74, 139.7, 151.2, 2.3),
  lat = c(40.7, 35.7, -33.9, 48.9)
)
gnomonic_fwd(cities, lon0 = -0.1, lat0 = 51.5)

# Great circle route appears as straight line
# London to NYC path
path <- geodesic_path(c(-0.1, 51.5), c(-74, 40.7), n = 10)
projected <- gnomonic_fwd(cbind(path$lon, path$lat), lon0 = -37, lat0 = 46)
# x and y should be approximately linear
plot(projected$x, projected$y, type = "l")
}
\seealso{
\code{\link[=azeq_fwd]{azeq_fwd()}} for azimuthal equidistant projection
}
