% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_snps.R
\name{select_snps}
\alias{select_snps}
\title{GWAS with SLOPE}
\usage{
select_snps(
  clumpingResult,
  fdr = 0.1,
  type = c("slope", "smt"),
  lambda = "gaussian",
  sigma = NULL,
  verbose = TRUE
)
}
\arguments{
\item{clumpingResult}{clumpProcedure output}

\item{fdr, }{numeric, False Discovery Rate for SLOPE}

\item{type}{method for snp selection. slope (default value) is SLOPE
on clump representatives, smt is Benjamini-Hochberg procedure on
single marker test p-values for clump representatives}

\item{lambda}{lambda for SLOPE. See \code{\link{create_lambda}}}

\item{sigma}{numeric, sigma for SLOPE}

\item{verbose}{logical, if TRUE progress bar is printed}
}
\value{
object of class \code{\link{selectionResult}}
}
\description{
Performs GWAS with SLOPE on given snp matrix and phenotype.
At first clumping procedure is performed. Highly correlated
(that is stronger than parameter \emph{rho}) snps are clustered.
Then SLOPE is used on snp matrix which contains
one representative for each clump.
}
\examples{
\dontrun{
slope.result <- select_snps(clumping.result, fdr=0.1)
}
}
