% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect.data_request}
\alias{collect.data_request}
\alias{collect.metadata_request}
\alias{collect.files_request}
\alias{collect.query}
\alias{collect.computed_query}
\title{Retrieve a database query}
\usage{
\method{collect}{data_request}(x, ..., wait = TRUE, file = NULL)

\method{collect}{metadata_request}(x, ...)

\method{collect}{files_request}(x, ...)

\method{collect}{query}(x, ..., wait = TRUE, file = NULL)

\method{collect}{computed_query}(x, ..., wait = TRUE, file = NULL)
}
\arguments{
\item{x}{An object of class \code{data_request}, \code{metadata_request} or
\code{files_request} (from \code{galah_call()}); or an object of class \code{query_set} or
\code{query} (from \code{collapse()} or \code{compute()})}

\item{...}{Arguments passed on to other methods}

\item{wait}{logical; should \code{galah} wait for a response? Defaults to FALSE.
Only applies for \code{type = "occurrences"} or \code{"species"}.}

\item{file}{(Optional) file name. If not given, will be set to \code{data} with
date and time added. The file path (directory) is always given by
\code{galah_config()$package$directory}.}
}
\value{
In most cases, \code{collect()} returns a \code{tibble} containing requested
data. Where the requested data are not yet ready (i.e. for occurrences when
\code{wait} is set to \code{FALSE}), this function returns an object of class \code{query}
that can be used to recheck the download at a later time.
}
\description{
\code{collect()} attempts to retrieve the result of a query from the
selected API.
}
