% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{g6_layout}
\alias{g6_layout}
\title{Set the layout algorithm for a g6 graph}
\usage{
g6_layout(graph, layout = d3_force_layout())
}
\arguments{
\item{graph}{A g6 graph object created with \code{g6()}.}

\item{layout}{An existing layout function like \link{circular_layout} or a string like \code{circular-layout}.
At minimum, this can be a list that should contain a \code{type} element specifying the layout algorithm.
Additional parameters depend on the layout type chosen, for instance \code{list(type = "force")}.}
}
\value{
The modified g6 graph object with the specified layout, allowing for method chaining.
}
\description{
This function configures the layout algorithm used to position nodes in a g6 graph.
}
\details{
G6 provides several layout algorithms, each suitable for different graph structures:

\itemize{
\item \strong{force}: Force-directed layout using physical simulation of forces.
\item \strong{random}: Random layout placing nodes randomly.
\item \strong{circular}: Arranges nodes on a circle.
\item \strong{radial}: Radial layout with nodes arranged outward from a central node.
\item \strong{grid}: Arranges nodes in a grid pattern.
\item \strong{concentric}: Concentric circles with important nodes in the center.
\item \strong{dagre}: Hierarchical layout for directed acyclic graphs.
\item \strong{fruchterman}: Force-directed layout based on the Fruchterman-Reingold algorithm.
\item \strong{mds}: Multidimensional scaling layout.
\item \strong{comboForce}: Force-directed layout specially designed for combo graphs.
}

Each layout algorithm has specific configuration options. See the G6 documentation
for detailed information on each layout and its parameters:
\url{https://g6.antv.antgroup.com/en/manual/layout/overview}.
}
\seealso{
\code{\link[=g6]{g6()}}
}
