% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{cov_mfd}
\alias{cov_mfd}
\title{Covariance Function for Multivariate Functional Data}
\usage{
cov_mfd(mfdobj1, mfdobj2 = mfdobj1)
}
\arguments{
\item{mfdobj1}{An object of class \code{mfd} representing the first multivariate functional data set.
It contains \eqn{N} observations of a \eqn{p}-dimensional multivariate functional variable.}

\item{mfdobj2}{An object of class \code{mfd} representing the second multivariate functional data set.
Defaults to \code{mfdobj1}. If provided, it must also contain \eqn{N} observations of a \eqn{p}-dimensional
multivariate functional variable.}
}
\value{
A bifd object representing the covariance function of the two input objects. The output
is a collection of \eqn{p^2} functional surfaces, each corresponding to the covariance between
two components of the multivariate functional data.
}
\description{
Computes the covariance function for two multivariate functional data objects of class \code{mfd}.
}
\details{
The function calculates the covariance between all pairs of dimensions from the two multivariate
functional data objects. Each covariance is represented as a functional surface in the resulting
bifd object. The covariance function is useful for analyzing relationships between functional variables.
}
\examples{
\donttest{
library(funcharts)
data("air")
x <- get_mfd_list(air[1:3])
cov_result <- cov_mfd(x)
plot_bifd(cov_result)
}

}
