% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_profiling.R
\name{plotar}
\alias{plotar}
\title{Correlation plots}
\usage{
plotar(data, input, target, plot_type, path_out)
}
\arguments{
\item{data}{data frame source}

\item{input}{string input variable (if empty, it runs for all numeric variable), it can take a single character value or a character vector.}

\item{target}{string of the variable to predict, it supports binary or multinominal values.}

\item{plot_type}{Indicates the type of plot to retrieve, available values: "boxplot" or "histdens".}

\item{path_out}{path directory, if it has a value the plot is saved. To save in current directory path must be dot: "."}
}
\value{
Single or multiple plots specified by 'plot_type' parameter
}
\description{
Visual correlation analysis. Plot different graphs in order to expose the inner information of any numeric variable against the target variable
}
\examples{
\donttest{
## It runs for all numeric variables automatically
plotar(data=heart_disease, target="has_heart_disease", plot_type="histdens")

plotar(heart_disease, input = 'age', target = 'chest_pain', plot_type = "boxplot")
}
}
