% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_ignore.R
\name{write_ignore}
\alias{write_ignore}
\title{Create an enhanced \code{.gitignore} file}
\usage{
write_ignore(path = here::here(), .initialize_proj = FALSE)
}
\arguments{
\item{path}{Character string. Path to the project directory.}

\item{.initialize_proj}{Logical. TRUE only if starting a 
\code{froggeR::quarto_project()}.}
}
\value{
A \code{.gitignore} file with enhanced security rules. The file includes:\cr
* R data files (.RData, .rda, .rds)\cr
* Common data formats (CSV, Excel, text)\cr
* System and temporary files\cr
* IDE-specific files
}
\description{
This function creates a \code{.gitignore} file with enhanced security 
measures designed to help prevent accidental data leaks. The template includes 
comprehensive rules for common data file types and sensitive information.
}
\details{
If a \code{.gitignore} file already exists, the user will be prompted before any
overwriting occurs. The template provides substantial security enhancements
over basic \code{.gitignore} files.

WARNING: Always consult your organization's data security team before using git
with any sensitive or protected health information (PHI). This template helps
prevent accidental data exposure but should not be considered a complete
security solution.
}
\examples{
# Create a temporary directory for testing
tmp_dir <- tempdir()

# Write the .gitignore file
write_ignore(path = tmp_dir)

# Confirm the file was created (optional, for user confirmation)
file.exists(file.path(tmp_dir, ".gitignore"))

# Clean up: Remove the created file
unlink(file.path(tmp_dir, ".gitignore"))

}
