% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs4Dash_theme.R
\name{bs4Dash_theme}
\alias{bs4Dash_theme}
\title{Create a theme for bs4Dash}
\usage{
bs4Dash_theme(
  primary = NULL,
  secondary = NULL,
  success = NULL,
  info = NULL,
  warning = NULL,
  danger = NULL,
  ...
)
}
\arguments{
\item{primary}{A color to be used for hyperlinks, to indicate primary/default
actions, and to show active selection state in some Bootstrap components.
Generally a bold, saturated color that contrasts with the theme's base
colors.}

\item{secondary}{A color for components and messages that don't need to stand
out. (Not supported in Bootstrap 3.)}

\item{success}{A color for messages that indicate an operation has succeeded.
Typically green.}

\item{info}{A color for messages that are informative but not critical.
Typically a shade of blue-green.}

\item{warning}{A color for warning messages. Typically yellow.}

\item{danger}{A color for errors. Typically red.}

\item{...}{Additional AdminLTE variables.}
}
\value{
Returns a \code{\link[sass:sass_layer]{sass::sass_bundle()}} (list-like) object.
}
\description{
Create a theme for bs4Dash
}
\examples{


library(shiny)
library(bs4Dash)
library(fresh)

ui <- dashboardPage(
  options = NULL,
  header = dashboardHeader(
    status = "primary",
    title = dashboardBrand(
      title = "My dashboard",
      color = "primary",
      href = "https://adminlte.io/themes/v3",
      image = "https://adminlte.io/themes/v3/dist/img/AdminLTELogo.png"
    )
  ),
  sidebar = dashboardSidebar(
    sidebarMenu(
      menuItem(
        text = "Tab 1",
        tabName = "tab1",
        icon = icon("van-shuttle")
      ),
      menuItem(
        text = "Tab 2",
        tabName = "tab2",
        icon = icon("shuttle-space")
      )
    )
  ),
  body = dashboardBody(
    use_theme(
      bs4Dash_theme(
        primary = "purple",
        success = "yellow",
        danger = "pink",
        "sidebar-light-bg" = "#C38AFF",
        "main-bg" = "#D9BBFF"
      )
    ),
    box(status = "danger", solidHeader = TRUE, title = "Title", "Content"),
    box(status = "primary", solidHeader = TRUE, title = "Title", "Content"),
    box(status = "success", solidHeader = TRUE, title = "Title", "Content")
  ),
  controlbar = dashboardControlbar(),
  title = "DashboardPage"
)


if (interactive()) {
  shinyApp(
    ui = ui,
    server = function(...) {}
  )
}

}
