% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{runSystemModel}
\alias{runSystemModel}
\title{Runs a system model and outputs the system performance}
\usage{
runSystemModel(sim, systemModel, systemArgs, metrics)
}
\arguments{
\item{sim}{list; a simulation containing the scenarios generated using the function \code{generateScenarios}.}

\item{systemModel}{a function; The function runs the system model using climate data in a data.frame as input.
The function is expected to be created by the user for specific system models. \code{tankWrapper} is an example system model function available in this package.
\code{runSystemModel} calls the function \code{systemModel} with two arguments:
\itemize{
\item \code{data}: data.frame; the climate data in a data frame with columns named \emph{year} \emph{month} \emph{day} \emph{*variable_name1*} \emph{*variable_name2*}. 
\item \code{systemArgs}: list; containing the other arguments required by the system model.\code{systemModel} unpack the arguments from the list and uses them as required. 
\item \code{metrics}: string vector; containing the names of the performance metrics that the system model returns. It is recommended that the
names also contain the units of the metric. See \code{viewTankMetrics()} for examples.
}}

\item{systemArgs}{a list; containing the input arguments to \code{systemModel}.}

\item{metrics}{a string vector; the names of the performance metrics the \code{systemModel} function returns.}
}
\value{
The function returns a list containing the performance metrics calculated by the \code{systemModel}. Each element of the list corresponds to a performance metric and is named using the \code{metrics} argument.
Each element contains performance values calculated at all the target points in the exposure space in a matrix with nrow corresponding to the targets and ncol corresponding to the replicates.
}
\description{
\code{runSystemModel} uses time series of hydroclimatic variables generated using the function \code{generateScenarios} as input to a systemModel and
collates the system performance for all the targets and replicates in the scenarios.
}
\details{
The \code{runSystemModel} function code is structured to be simple and may be used as an example to create scripts that use scenarios
generated using \code{generateScenarios} to run system models in other programming languages. Type \code{runSystemModel} to view the function code.
The function \code{tankWrapper} in this package may be used as an example to create user defined functions for the \code{systemModel} argument.
Refer to \code{tankWrapper} to understand how the \code{systemModel} is expected to use \code{systemArgs} and return the calculated performance metrics.
The \code{systemModel} function is expected to return a named list of performance metrics. The elements of the vector should correspond to \code{metrics}.
}
\examples{
# Example using tankWrapper as the systemModel
#=====================================================
\dontrun{
# create an exposure space
attPerturb <- c("P_ann_tot_m", "P_ann_nWet_m")
attHold <- c("P_Feb_tot_m", "P_SON_dyWet_m", "P_JJA_avgWSD_m", "P_MAM_tot_m",
"P_DJF_avgDSD_m", "Temp_ann_rng_m", "Temp_ann_avg_m")
attPerturbType = "regGrid"
attPerturbSamp = c(2, 2)
attPerturbMin = c(0.9, 0.9)
attPerturbMax = c(1.1, 1.1)
expSpace <- createExpSpace(attPerturb = attPerturb,
                           attPerturbSamp = attPerturbSamp,
                           attPerturbMin = attPerturbMin,
                           attPerturbMax = attPerturbMax,
                           attPerturbType = attPerturbType,
                           attHold = attHold,
                           attTargetsFile = NULL)
# load example observed data available in foreSIGHT
data(tankDat)
# perform stochastic simulation
sim <- generateScenarios(reference = tank_obs,
                                  expSpace = expSpace,
                                  simLengthNyrs = 30)
# use the simulation to run a system model
systemArgs <- list(roofArea = 205, nPeople = 1, tankVol = 2400,
firstFlush = 2.0, write.file = FALSE)
tankMetrics <- viewTankMetrics()
systemPerf = runSystemModel(sim = sim,
                            systemModel = tankWrapper,
                            systemArgs = systemArgs,
                            metrics = tankMetrics[1:2])
                            }
}
\seealso{
\code{tankWrapper}, \code{generateScenarios}
}
