% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Punting}
\alias{Punting}
\title{American football punting}
\format{
A data frame with 13 observations on the following 7 variables.
\describe{ 
\item{distance}{ mean distance for 10 punts (feet) }
\item{hang}{ mean hang time (seconds) }
\item{rStrength}{ right leg strength (pounds)}
\item{lStrength}{ left leg strength (pounds)}
\item{rFlexibility}{ right leg flexibility (degrees)}
\item{lFlexibility}{ left leg flexibility (degrees)}
\item{oStrength}{ overall leg strength (foot-pounds)} }
}
\source{
These data are also available at OzDASL
(\url{https://dasl.datadescription.com/}).
}
\description{
Investigators studied physical characteristics and ability in 13 football
punters. Each volunteer punted a football ten times. The investigators
recorded the average distance for the ten punts, in feet. They also recorded
the average hang time (time the ball is in the air before the receiver
catches it), and a number of measures of leg strength and flexibility.
}
\examples{

data(Punting)
gf_point(hang ~ distance, data = Punting)

}
\references{
"The relationship between selected physical performance
variables and football punting ability" by the Department of Health,
Physical Education and Recreation at the Virginia Polytechnic Institute and
State University, 1983.
}
\keyword{datasets}
