% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-lpfilt.R
\name{lpfilt_pupil}
\alias{lpfilt_pupil}
\title{Internal function to lowpass filter pupil data}
\usage{
lpfilt_pupil(x, prev_op, wp, ws, rp, rs, fs, plot_freqz)
}
\arguments{
\item{x}{A data frame containing pupil data}

\item{prev_op}{The name of the previous operation in the pipeline}

\item{wp}{The end of passband frequency in Hz (desired lowpass cutoff)}

\item{ws}{The start of stopband frequency in Hz (required lowpass cutoff)}

\item{rp}{Required maximal ripple within passband in dB}

\item{rs}{Required minimal attenuation within stopband in dB}

\item{fs}{The sample rate of the data}

\item{plot_freqz}{A flag to indicate whether to display the filter frequency
response}
}
\value{
A vector of filtered pupil data
}
\description{
This function lowpass filters pupil data using a Butterworth
filter.

This function is called by the exposed wrapper \code{\link[=lpfilt]{lpfilt()}}
}
\keyword{internal}
