% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_event.R
\name{step_time_event}
\alias{step_time_event}
\alias{tidy.step_time_event}
\title{Indicate Recurrent Date Time Event}
\usage{
step_time_event(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  rules = list(),
  columns = NULL,
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("time_event")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[recipes:selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{rules}{Named list of \code{almanac} rules.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{\link[recipes:prep]{recipes::prep.recipe()}} is used.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{TRUE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new check added to the
sequence of any existing operations.
}
\description{
\code{step_time_event()} creates a \emph{specification} of a recipe step that will
create new columns indicating if the date fall on recurrent event.
}
\details{
Unlike some other steps \code{step_time_event} does \emph{not} remove the
original date variables by default. Set \code{keep_original_cols} to \code{FALSE} to
remove them.
}
\examples{
library(recipes)
library(extrasteps)
library(almanac)
library(modeldata)

data(Chicago)

on_easter <- yearly() \%>\% recur_on_easter()
on_weekend <- weekly() \%>\% recur_on_weekends()

rules <- list(easter = on_easter, weekend = on_weekend)

rec_spec <- recipe(ridership ~ date, data = Chicago) \%>\%
  step_time_event(date, rules = rules)

rec_spec_preped <- prep(rec_spec)

bake(rec_spec_preped, new_data = NULL)
}
