% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ernm.R
\name{createCppModel}
\alias{createCppModel}
\title{Creates a C++ representation of an ERNM model}
\usage{
createCppModel(
  formula,
  ignoreMnar = TRUE,
  cloneNet = TRUE,
  theta = NULL,
  modelArgs = list(modelClass = "Model")
)
}
\arguments{
\item{formula}{the model formula (see \code{\link{ernm-formula}})}

\item{ignoreMnar}{ignore missing not at random offsets}

\item{cloneNet}{should the network be cloned}

\item{theta}{the model parameters.}

\item{modelArgs}{additional arguments for the model, e.g. tapering parameters}
}
\value{
a Model object
}
\description{
Creates a C++ representation of an ERNM model
}
\examples{
\dontrun{
edge_list <- matrix(numeric(),ncol=2)
net <- new(UndirectedNet,edge_list,5)

rcpp_model <- createCppModel(net ~ edges(), theta = 0)

rcpp_sampler <- new(UndirectedMetropolisHastings, rcpp_model)

# Run MCMC to generate 30 networks with burnin=10 and an interval of 20 steps between each network
networks <- rcpp_sampler$generateSample(10,20,30)

sapply(networks, function(net) net$nEdges()) # number of edges in each network
}

}
