% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSIRLogit.R
\name{ModelSIRLogit}
\alias{ModelSIRLogit}
\title{SIR Logistic model}
\usage{
ModelSIRLogit(
  vname,
  data,
  coefs_infect,
  coefs_recover,
  coef_infect_cols,
  coef_recover_cols,
  prob_infection,
  recovery_rate,
  prevalence
)
}
\arguments{
\item{vname}{Name of the virus.}

\item{data}{A numeric matrix with \code{n} rows.}

\item{coefs_infect}{Numeric vector. Coefficients associated to infect.}

\item{coefs_recover}{Numeric vector. Coefficients associated to recover.}

\item{coef_infect_cols}{Integer vector. Columns in the coeficient.}

\item{coef_recover_cols}{Integer vector. Columns in the coeficient.}

\item{prob_infection}{Numeric scalar. Baseline probability of infection.}

\item{recovery_rate}{Numeric scalar. Baseline probability of recovery.}

\item{prevalence}{Numeric scalar. Prevalence (initial state) in proportion.}
}
\value{
\itemize{
\item The \code{ModelSIRLogit} function returns a model of class \link{epiworld_model}.
}
}
\description{
SIR Logistic model
}
\section{Model diagram}{

\figure{sirlogit.png}{SIR Logit Diagram}
}

\examples{
set.seed(2223)
n <- 100000

# Creating the data to use for the "ModelSIRLogit" function. It contains
# information on the sex of each agent and will be used to determine
# differences in disease progression between males and females. Note that
# the number of rows in these data are identical to n (100000).
X <- cbind(
  Intercept = 1,
  Female    = sample.int(2, n, replace = TRUE) - 1
)

# Declare coefficients for each sex regarding transmission_rate and recovery.
coef_infect  <- c(.1, -2, 2)
coef_recover <- rnorm(2)

# Feed all above information into the "ModelSIRLogit" function.
model_logit <- ModelSIRLogit(
  "covid2",
  data = X,
  coefs_infect      = coef_infect,
  coefs_recover     = coef_recover,
  coef_infect_cols  = 1L:ncol(X),
  coef_recover_cols = 1L:ncol(X),
  prob_infection = .8,
  recovery_rate = .3,
  prevalence = .01
)

agents_smallworld(model_logit, n, 8, FALSE, .01)

run(model_logit, 50)

plot(model_logit)

# Females are supposed to be more likely to become infected.
rn <- get_reproductive_number(model_logit)

# Probability of infection for males and females.
(table(
  X[, "Female"],
  (1:n \%in\% rn$source)
) |> prop.table())[, 2]

# Looking into the individual agents.
get_agents(model_logit)
}
\seealso{
Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelMeaslesMixing}()},
\code{\link{ModelMeaslesMixingRiskQuarantine}()},
\code{\link{ModelMeaslesSchool}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSEIRMixingQuarantine}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
\concept{general-models}
