% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independent_eval.R
\name{independent_eval1}
\alias{independent_eval1}
\alias{independent_eval01}
\title{Evaluate final models using independent data}
\usage{
independent_eval1(prediction, threshold, test_prediction = NULL,
                  lon_lat = NULL)

independent_eval01(prediction, observation, lon_lat = NULL)
}
\arguments{
\item{prediction}{(numeric) vector or \code{SpatRaster} object. If numeric,
predicted values in independent data (for \code{\link{independent_eval01}}),
or the entire area of prediction (for \code{\link{independent_eval1}}).
If \code{SpatRaster} prediction over the area of interest.}

\item{threshold}{(numeric) the lowest predicted probability value for an
occurrence point. This value must be defined for presences-only data.
Default = NULL.}

\item{test_prediction}{(numeric) vector of predictions for independent data.
Default = NULL.}

\item{lon_lat}{matrix or data.frame of coordinates (longitude and latitude,
in that order) of independent data. Points must be located within the valid
area of \code{prediction}. For \code{\link{independent_eval01}} they
must correspond with values in observation.}

\item{observation}{(numeric) vector of observed (known) values of presence
or absence to test against \code{prediction} (if numeric) or values of prediction
in \code{lon_lat}.}
}
\value{
A data.frame or list containing evaluation results.
}
\description{
Final evaluation steps for model predictions using an independent dataset
(not used in model calibration).
}
\examples{
# Independent test data based on coordinates (lon/lat WGS 84) from presence
# and absences records
data("test", package = "enmpa")
head(test)

# Loading a model prediction
pred <- terra::rast(system.file("extdata", "proj_out_wmean.tif",
                                package = "enmpa"))
terra::plot(pred)

# Evaluation using presence-absence data
independent_eval01(prediction = pred, observation = test$Sp,
                   lon_lat = test[, 2:3])

# Evaluation using presence-only data
test_p_only <- test[test$Sp == 1, ]
th_maxTSS   <- 0.1274123            # threshold based on the maxTSS

independent_eval1(prediction = pred, threshold = th_maxTSS,
                  lon_lat = test_p_only[, 2:3])
}
