% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFric.R
\name{MFric}
\alias{MFric}
\title{Calculate Multifunctionality Richness (MFric)}
\usage{
MFric(data, weights = NULL, cor = FALSE)
}
\arguments{
\item{data}{A numeric data frame or matrix where rows represent observations (e.g., sites, plots)
and columns represent different ecosystem functions.}

\item{weights}{A numeric vector of weights for each function (column) in the data.
If NULL (default), equal weights of 1 are assigned to all functions.}

\item{cor}{Logical. If FALSE (default), calculates uncorrected MFric.
If TRUE, calculates correlation-corrected MFric accounting for redundancy among functions.}
}
\value{
A data frame with a single column named "MFric" containing the calculated
  Multifunctionality Richness values for each row in the input data.
  Row names are preserved from the input data if available.
}
\description{
This function calculates the Multifunctionality Richness (MFric) for each row in a dataset.
MFric represents the average level of multiple ecosystem function indicators, reflecting
the overall performance of an ecosystem across various functional metrics.
}
\details{
The uncorrected MFric is calculated as:
\deqn{MFric = \frac{\sum_{i=1}^{n} w_i f_i}{\sum_{i=1}^{n} w_i}}
where fi represents the normalized performance level of function i, and wi denotes the weight assigned to function i.

When redundancy correction is applied (`cor = TRUE`), the function accounts for correlations
between ecosystem functions. The correction process involves:

1. Calculating a distance matrix based on correlations: \eqn{d_{ij} = \sqrt{1 - |r_{ij}|}}

2. Applying threshold-based correction: \eqn{d_{ij}(\tau) = \min(d_{ij}, \tau)}

3. Computing effective function values:
   \eqn{F_i(\tau) = \sum_{j=1}^{L}(1 - \frac{d_{ij}(\tau)}{\tau})f_j}

4. Calculating the corrected MFric using these effective function values:
   \deqn{MFric = \frac{\sum_{i=1}^{n} w_i F_i}{\sum_{i=1}^{n} w_i}}

5. The final result is the area under the curve (AUC) of MFric values across different tau thresholds.
}
\examples{
data(forestfunctions)
head(forestfunctions)
MFric(forestfunctions[,6:31], cor = FALSE)

}
