% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectorySections.R
\encoding{UTF-8}
\name{trajectorySections}
\alias{trajectorySections}
\alias{extractTrajectorySections}
\alias{interpolateEcolStates}
\alias{sections}
\title{Functions for building Trajectory Sections}
\usage{
extractTrajectorySections(
  x,
  Traj,
  tstart,
  tend,
  BCstart,
  BCend,
  namesTS = 1:length(Traj)
)
}
\arguments{
\item{x}{An object of class \code{\link{trajectories}} describing a cyclical trajectory.}

\item{Traj}{A vector of length equal to the number of desired trajectory sections indicating the trajectories from which trajectory sections must be build (see details).}

\item{tstart}{A vector of start times for each of the desired trajectory sections (see details).}

\item{tend}{A vector of end times for each of the desired trajectory sections (see details).}

\item{BCstart}{A vector of start boundary conditions (either \code{"internal"} or \code{"external"}) for each of the desired trajectory sections (see details).}

\item{BCend}{A vector of end boundary conditions (either \code{"internal"} or \code{"external"}) for each of the desired trajectory sections (see details).}

\item{namesTS}{An optional vector giving a name for each of the desired trajectory sections (by default trajectory sections are simply numbered).}
}
\value{
Function \code{extractTrajectorySections} returns the base information needed to describe trajectory sections. Its outputs are meant to be used as inputs for other ETA functions in order to obtain desired metrics. Importantly, within trajectory sections, ecological states can be considered "internal" or "external" and may necessitate special treatment (see details). Function \code{extractTrajectorySections} returns an object of class \code{\link{sections}} containing:
\itemize{
\item{\code{d}: an object of class \code{\link{dist}}, the new distance matrix describing the trajectory sections. Ecological states may be duplicated in this matrix if trajectory sections overlap. As compared to the input matrix, \code{d} may also present deletions of ecological states that do not belong to any trajectory sections.}
\item{\code{metadata}: an object of class \code{\link{data.frame}} describing the ecological states in \code{d} with columns:
\itemize{
\item{\code{sites}: the sites associated to each ecological states.}
\item{\code{sections}: the names of the trajectory sections each ecological states belongs to.}
\item{\code{surveys}: renumbering of the surveys to describe individual trajectory sections.}
\item{\code{times}: the times associated to each ecological states.}
\item{\code{internal}: a boolean vector with \code{TRUE} indicating "internal" ecological states whereas \code{FALSE} indicates "external" ecological states. This has important implications for the use of \code{extractTrajectorySections} outputs (see details).}
}
}
\item{\code{interpolationInfo}: an output that only appear if ecological states have been interpolated. It is used internally by plotting functions (see \code{cyclePCoA}) but is not intended to be of interest to the end user.}
}

Function \code{interpolateEcolStates} returns an object of class \code{\link{dist}} including the desired interpolated ecological states.
}
\description{
Trajectory sections are flexible way to cut longer trajectories. They are presently used chiefly in building cycles for cyclical ecological trajectory analysis (CETA) but might have other applications.
}
\details{
Trajectory sections functions:
\itemize{
\item{Function \code{extractTrajectorySections} reformats an object of class \code{\link{trajectories}} describing one or more trajectories into another object of class \code{\link{trajectories}} describing specified trajectory sections. Trajectory sections represent a way to subset trajectories flexibly. Cycles (see \code{\link{extractCycles}}) are a particular case of trajectory sections.}
\item{Function \code{interpolateEcolStates} compute interpolated ecological states and the new distance matrix associated (used in extractTrajectorySections).}
}

Trajectory sections can be obtained using \code{extractTrajectorySections}. Trajectory sections allow to cut a longer trajectory into parts for further analyses. Cycles are specical case of trajectory sections.
A trajectory section TS(Traj,(tstart, BCstart),(tend, BCend)) is defined by the trajectory (Traj) it is obtained from, by an start and end times (tstart and tend) and start and end boundary conditions (BCstart, BCend).
The function extractTrajectorySections builds trajectory sections as a function of its arguments \code{Traj}, \code{tstart}, \code{tend}, \code{BCstart}, \code{BCend}.

Function \code{interpolateEcolStates} is called within \code{extractTrajectorySections} to interpolate ecological states when \code{tstart} and or \code{tend} do not have an associated measured ecological state within matrix \code{d}.

IMPORTANT: Trajectory sections comprises both "internal" and "external" ecological states (indicated in vector \code{internal}, see the output of function \code{extractTrajectorySections}).
"external" ecological states need a specific treatment in some calculations and for some operations within ETA, namely:
\itemize{
\item{Centering, where external ecological states must be excluded from computation but included nonetheless in the procedure. This is automatically handled by function \code{\link{centerTrajectories}}.}
\item{Trajectory variability, where only internal ecological states must be taken in account. This is handled automatically by function \code{\link{trajectoryInternalVariation}}.}
}
Special care must also be taken when processing the data through principal coordinate analysis as external ecological states are effectively duplicated or interpolated in the output of \code{extractTrajectorySections}.
}
\examples{
#Description of sites and surveys
sites <- c("1","1","1","2","2","2")
surveys <- c(1, 2, 3, 1, 2, 3)
times <- c(0, 1.5, 3, 0, 1.5, 3)
  
#Raw data table
xy <- matrix(0, nrow=6, ncol=2)
xy[2,2]<-1
xy[3,2]<-2
xy[4:6,1] <- 0.5
xy[4:6,2] <- xy[1:3,2]
xy[6,1]<-1

#Draw trajectories
trajectoryPlot(xy, sites, surveys,  
               traj.colors = c("black","red"), lwd = 2)
               
#Distance matrix
d <- dist(xy)
d
  
#Trajectory data
x <- defineTrajectories(d, sites, surveys, times)

#Cutting some trajectory sections in those trajectories
TrajSec <- extractTrajectorySections(x,
                                     Traj = c("1","1","2"),
                                     tstart = c(0,1,0.7),
                                     tend = c(1.2,2.5,2),
                                     BCstart = rep("internal",3),
                                     BCend = rep("internal",3))
#extractTrajectorySections() works from distances, 
#so for representation using trajectoryPlot(),we must first perform a PCoA:
Newxy <- cmdscale(TrajSec$d)
trajectoryPlot(Newxy,
               sites = TrajSec$metadata$sections,
               surveys = TrajSec$metadata$surveys,
               traj.colors = c("black","grey","red"),lwd = 2)


}
\author{
Nicolas Djeghri, UBO

Miquel De \enc{Cáceres}{Caceres}, CREAF
}
\keyword{internal}
