% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyPubMed_scr.R
\name{trim_address}
\alias{trim_address}
\title{Trim and Format Address Information}
\usage{
trim_address(addr)
}
\arguments{
\item{addr}{Character string including an address as extracted from PubMed records.}
}
\value{
Character string including a formatted and trimmed address (if available).
}
\description{
Set of rules for trimming and standardizing the format of address information 
retrieved from PubMed records. Affiliations including more than one address will be trimmend 
and only the first address will be returned.
}
\examples{
addr_string <- " 2 Dept of Urology, Feinberg School of Medicine," 
addr_string <- paste(addr_string, "Chicago, US; Dept of Mol Bio as well...")
print(addr_string)
print(trim_address(addr = addr_string))

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
