% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_export.R
\name{import_var_classes}
\alias{import_var_classes}
\title{Import corrected variable classes}
\usage{
import_var_classes(file = "./datatypes.csv")
}
\arguments{
\item{file}{character string. Path to output of
\code{\link{assume_var_classes}} which should be manually verified outside
of \R and corrected where any data type is incorrect.}
}
\value{
data frame containing the data type values of variables, as described
  in \code{file}
}
\description{
Reads in output of \code{\link{assume_var_classes}}, ensures all specified
datatypes are one of ("id", "numeric", "double", "integer", "character",
"factor","ordinal", "genotype", "freetext", "logical") as required for high
level 'eHDPrep' functions.
}
\examples{
tmp = tempfile(fileext = ".csv")
data(example_data)
assume_var_classes(example_data, tmp)
import_var_classes(tmp)

}
\seealso{
\code{\link[eHDPrep]{assume_var_classes}}
}
