% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_clean.R
\name{encode_as_num_mat}
\alias{encode_as_num_mat}
\title{Convert data frame to numeric matrix}
\usage{
encode_as_num_mat(data, id_var)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{id_var}{An unquoted  expression which corresponds to a variable in
\code{data} which identifies each row.}
}
\value{
Numeric matrix with \code{id_var} values as row names
}
\description{
Converts all columns to numeric and uses the row identifier column
(\code{id_var}) as row names.
}
\examples{
require(dplyr)
require(magrittr)
mtcars \%>\%
  dplyr::as_tibble(rownames = "id") \%>\%
  encode_as_num_mat(id)
}
