//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_serialization.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#include "duckdb/common/serializer/serializer.hpp"
#include "duckdb/common/serializer/deserializer.hpp"
#include "duckdb/catalog/dependency.hpp"
#include "duckdb/catalog/dependency_list.hpp"

namespace duckdb {

void CatalogEntryInfo::Serialize(Serializer &serializer) const {
	serializer.WriteProperty<CatalogType>(100, "type", type);
	serializer.WritePropertyWithDefault<string>(101, "schema", schema);
	serializer.WritePropertyWithDefault<string>(102, "name", name);
}

CatalogEntryInfo CatalogEntryInfo::Deserialize(Deserializer &deserializer) {
	CatalogEntryInfo result;
	deserializer.ReadProperty<CatalogType>(100, "type", result.type);
	deserializer.ReadPropertyWithDefault<string>(101, "schema", result.schema);
	deserializer.ReadPropertyWithDefault<string>(102, "name", result.name);
	return result;
}

void LogicalDependency::Serialize(Serializer &serializer) const {
	serializer.WriteProperty<CatalogEntryInfo>(100, "entry", entry);
	serializer.WritePropertyWithDefault<string>(101, "catalog", catalog);
}

LogicalDependency LogicalDependency::Deserialize(Deserializer &deserializer) {
	auto entry = deserializer.ReadProperty<CatalogEntryInfo>(100, "entry");
	auto catalog = deserializer.ReadPropertyWithDefault<string>(101, "catalog");
	LogicalDependency result(deserializer.TryGet<Catalog>(), entry, std::move(catalog));
	return result;
}

void LogicalDependencyList::Serialize(Serializer &serializer) const {
	serializer.WriteProperty<create_info_set_t>(100, "set", set);
}

LogicalDependencyList LogicalDependencyList::Deserialize(Deserializer &deserializer) {
	LogicalDependencyList result;
	deserializer.ReadProperty<create_info_set_t>(100, "set", result.set);
	return result;
}

} // namespace duckdb
