% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WikiEvent2018.R
\docType{data}
\name{WikiEvent2018.first100k}
\alias{WikiEvent2018.first100k}
\title{Wikipedia Edit Event Sequence 2018}
\format{
\subsection{\code{WikiEvent2018.first100k}}{

The first 100,000 events of the Wikipedia edit event sequence, where an event
is described as a Wikipedia user editing a Wikipedia article. The user column
represents the unique event senders, the article column represents the unique
event receivers (targets), and the time variable is in milliseconds.
\describe{
\item{user}{the column that represents the unique event senders.}
\item{article}{the article column represents the unique event receivers.}
\item{time}{the event time variable in milliseconds.}
\item{eventID}{the numerical id for each event in the event sequence}
}
}
}
\source{
\url{https://zenodo.org/records/1626323}

Lerner, Jurgen and Alessandro Lomi. 2020. "Reliability of relational event model estimates
under sampling: how to fit a relational event model to 360 million dyadic events."
\emph{Network Science} 8(1):97-135. (DOI: https://doi.org/10.1017/nws.2019.57)
}
\usage{
data(WikiEvent2018.first100k)
}
\description{
The first 100,000 events of the (two-mode) Wikipedia edit event sequence, where
an event is described as a Wikipedia user editing a Wikipedia article. The user
column represents the unique event senders, the article column represents the unique
event receivers (targets), and the time variable is in milliseconds.
}
\keyword{datasets}
