% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{airrClone-class}
\alias{airrClone-class}
\alias{airrClone}
\title{S4 class defining a clone in Dowser}
\description{
\code{airrClone} defines a common data structure for perform lineage recontruction
from AIRR data, based heavily on alakazam::ChangeoClone.
}
\section{Slots}{

\describe{
\item{\code{data}}{data.frame containing sequences and annotations. Contains the
columns \code{sequence_id} and \code{sequence}, as well as any additional 
sequence-specific annotation columns}

\item{\code{clone}}{string defining the clone identifier}

\item{\code{germline}}{string containing the heavy chain germline sequence for the clone}

\item{\code{lgermline}}{string containing the light chain germline sequence for the clone}

\item{\code{hlgermline}}{string containing the combined germline sequence for the clone}

\item{\code{v_gene}}{string defining the V segment gene call}

\item{\code{j_gene}}{string defining the J segment gene call}

\item{\code{junc_len}}{numeric junction length (nucleotide count)}

\item{\code{locus}}{index showing which locus represented at each site}

\item{\code{region}}{index showing FWR/CDR region for each site}

\item{\code{phylo_seq}}{sequence column used for phylogenetic tree building}

\item{\code{numbers}}{index (usually IMGT) number of each site in \code{phylo_seq}}
}}

\seealso{
See \link{formatClones} for use.
}
