% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_category}
\alias{compare_category}
\alias{compare_category.data.frame}
\title{Compare categorical variables}
\usage{
compare_category(.data, ...)

\method{compare_category}{data.frame}(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link[tibble]{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}
}
\value{
An object of the class as compare based list.
The information to examine the relationship between categorical variables is as follows each components.

\itemize{
\item var1 : factor. The level of the first variable to compare. 'var1' is the name of the first variable to be compared.
\item var2 : factor. The level of the second variable to compare. 'var2' is the name of the second variable to be compared.
\item n : integer. frequency by var1 and var2.
\item rate : double. relative frequency.
\item first_rate : double. relative frequency in first variable.
\item second_rate : double. relative frequency in second variable.
}
}
\description{
The compare_category() compute information to examine the relationship 
between categorical variables.
}
\details{
It is important to understand the relationship between categorical variables in EDA.
compare_category() compares relations by pair combination of all categorical variables. 
and return compare_category class that based list object.
}
\section{Attributes of return object}{

Attributes of compare_category class is as follows.
\itemize{
\item variables : character. List of variables selected for comparison.
\item combination : matrix. It consists of pairs of variables to compare.
}
}

\examples{
\donttest{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

library(dplyr)

# Compare the all categorical variables
all_var <- compare_category(heartfailure2)

# Print compare_numeric class objects
all_var

# Compare the categorical variables that case of joint the death_event variable
all_var \%>\% 
  "["(grep("death_event", names(all_var)))

# Compare the two categorical variables
two_var <- compare_category(heartfailure2, smoking, death_event)

# Print compare_category class objects
two_var

# Filtering the case of smoking included NA 
two_var \%>\%
  "[["(1) \%>\% 
  filter(!is.na(smoking))

# Summary the all case : Return a invisible copy of an object.
stat <- summary(all_var)

# Summary by returned objects
stat

# component of table 
stat$table

# component of chi-square test 
stat$chisq

# component of chi-square test 
summary(all_var, "chisq")

# component of chi-square test (first, third case)
summary(all_var, "chisq", pos = c(1, 3))

# component of relative frequency table 
summary(all_var, "relative")

# component of table without missing values 
summary(all_var, "table", na.rm = TRUE)

# component of table include marginal value 
margin <- summary(all_var, "table", marginal = TRUE)
margin

# component of chi-square test 
summary(two_var, method = "chisq")

# verbose is FALSE 
summary(all_var, "chisq", verbose = FALSE)

#' # Using pipes & dplyr -------------------------
# If you want to use dplyr, set verbose to FALSE
summary(all_var, "chisq", verbose = FALSE) \%>\% 
  filter(p.value < 0.26)

# Extract component from list by index
summary(all_var, "table", na.rm = TRUE, verbose = FALSE) \%>\% 
  "[["(1)

# Extract component from list by name
summary(all_var, "table", na.rm = TRUE, verbose = FALSE) \%>\% 
  "[["("smoking vs death_event")

# plot all pair of variables
plot(all_var)

# plot a pair of variables
plot(two_var)

# plot all pair of variables by prompt
plot(all_var, prompt = TRUE)

# plot a pair of variables
plot(two_var, las = 1)
}

}
\seealso{
\code{\link{summary.compare_category}}, \code{\link{print.compare_category}}, \code{\link{plot.compare_category}}.
}
