% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abd_freq_count.R
\name{abd_freq_count}
\alias{abd_freq_count}
\title{Abundance Frequency Count of a Community}
\usage{
abd_freq_count(
  abd,
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "rarefy", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  check_arguments = TRUE
)
}
\arguments{
\item{abd}{A numeric vector containing species abundances.}

\item{level}{the level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{probability_estimator}{a string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{a string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{A string containing an estimator recognized by
\link{div_richness} to evaluate the total number of species in \link{probabilities}.
Used only for extrapolation.}

\item{jack_alpha}{the risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{the highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A two-column tibble. The first column contains the number of observations,
the second one the number of species observed this number of times.
}
\description{
Count the number of species observed the same number of times.
}
\details{
The Abundance Frequency Count \insertCite{Chao2015}{divent} is the number
of species observed each number of times.
It is a way to summarize the species distribution.

It can be estimated at a specified level of interpolation or extrapolation.
Extrapolation relies on the estimation of the estimation of the asymptotic
distribution of the community by \link{probabilities} and eq. (5)
of \insertCite{Chao2014}{divent}.
}
\examples{
abd_freq_count(as.numeric(paracou_6_abd[1, ]))
}
\references{
\insertAllCited{}
}
