# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' parallelCountNbd
#'
#' Create a 3-D array containing the number of neighbors around each point, per species
#'
#' @param r The vector of distances to take into account.
#' @param NbSpecies The number of species of the community.
#' @param x,y The coordinates of the points.
#' @param Type A vector containing the species of each point (as integer, i.e. the factor code).
#' @param Weight A vector containing the weights of points.
#' @returns a numeric vector with the distances to convert to a matrix
#' @noRd
#' @examples
#' # Build a point pattern
#' X <- rspcommunity(1, size = 5, species_number = 3)
#' if(require(spatstat.geom)) {
#'   # Compute the distances
#'   matrix(parallelCountNbd(r = 0:1, NbSpecies = 3, x= X$x, y = X$y, 
#'     Type = marks(X)$PointType, Weight = marks(X)$PointType), nrow = 5)
#' }
parallelCountNbd <- function(r, NbSpecies, x, y, Type, Weight) {
    .Call(`_divent_parallelCountNbd`, r, NbSpecies, x, y, Type, Weight)
}

