% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synoptique.R
\name{create_synoptique}
\alias{create_synoptique}
\title{Create a Synoptic Plot from a Given Tree Structure}
\usage{
create_synoptique(tree, option, depth = NA)
}
\arguments{
\item{tree}{\code{Tree} structure object.}

\item{option}{\code{list} containing evaluation options for the tree.}

\item{depth}{\code{numeric} representing the depth of the tree; if provided,
produces a sub-tree.}
}
\value{
A \code{ggplot} object representing the synoptic plot.
}
\description{
Generates a synoptic plot based on a specified tree structure, providing
visualization of its structure and evaluation options.
}
\examples{
tree <- dexisensitivity::masc2
option <- create_options(tree, num_options=1, seed = 42)
create_synoptique(tree, option)

}
