% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall.R
\name{d_overall}
\alias{d_overall}
\title{Determine overall desirability}
\usage{
d_overall(..., geometric = TRUE, tolerance = 0)
}
\arguments{
\item{...}{One or more unquoted expressions separated by commas. To choose
multiple columns using selectors, \code{\link[dplyr:across]{dplyr::across()}} can be used (see the
example below).}

\item{geometric}{A logical for whether the geometric or arithmetic mean
should be used to summarize the columns.}

\item{tolerance}{A numeric value where values strictly less than this value
are capped at the value. For example, if users wish to use the geometric mean
without completely excluding settings, a value greater than zero can be used.}
}
\value{
A numeric vector.
}
\description{
Once desirability columns have been created, determine the overall
desirability using a mean (geometric by default).
}
\examples{
\dontshow{if (rlang::is_installed("dplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

# Choose model tuning parameters that minimize the number of predictors used
# while maximizing the area under the ROC curve.

classification_results |>
  mutate(
    d_feat = d_min(num_features, 1, 200),
    d_roc  = d_max(roc_auc, 0.5, 0.9),
    d_all  = d_overall(across(starts_with("d_")))
  ) |>
  arrange(desc(d_all))

# Bias the ranking toward minimizing features by using a larger scale.

classification_results |>
  mutate(
    d_feat = d_min(num_features, 1, 200, scale = 3),
    d_roc  = d_max(roc_auc, 0.5, 0.9),
    d_all  = d_overall(across(starts_with("d_")))
  ) |>
  arrange(desc(d_all))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=d_max]{d_max()}}
}
