% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes-methods.R
\name{classify}
\alias{classify}
\alias{classify.ForestTrainParam}
\alias{classify.ForestTrainNonParam}
\title{Classify parts of images as forest / non-forest}
\usage{
classify(Model, ...)

\method{classify}{ForestTrainParam}(Model, data, n_pts, parallel = FALSE, progress = "text", ...)

\method{classify}{ForestTrainNonParam}(Model, data, n_pts, parallel = FALSE, progress = "text", ...)
}
\arguments{
\item{Model}{trained model, e.g. by \code{\link{train}}}

\item{...}{additional parameters passed to methods}

\item{data}{raster object. \code{\link{read_data_raster}}}

\item{n_pts}{size of sub-frames into which data is split}

\item{parallel}{Boolean. Whether to use parallel setup}

\item{progress}{progress bar. Works only when parallel=FALSE. Could be set to 'text' or 'none'}
}
\value{
a black-and-white image of the terrain data where white represents forest and black is for non-forest.
}
\description{
Generic function classify dispatches methods according to the class of object Model.
A chosen method takes raster object data and classifies parts of it as 1- forest or 0- non-forest.
}
\details{
Both classify.ForestTrainParam and classify.ForestTrainNonParam use parameter n_pts to split images
into square sub-frames of the size n_pts. Those sub-frames are classified independently and all pixels
from a sub-frame are tagged according to its classification result. When the image contained by data
is of dimensions that are not divisible by n_pts, it is truncated from the right and the bottom to
to make the largest divisible one. Thus, the result of classification can be of a different size than
the original image.
}
\section{Methods (by class)}{
\itemize{
\item \code{classify(ForestTrainParam)}: Method for the class ForestTrainParam

\item \code{classify(ForestTrainNonParam)}: Method for the class ForestTrainNonParam

}}
\examples{
library(deforestable)
n_pts <- 20

# Choosing folders with training data
Forestdir <- system.file('extdata/Forest/', package = "deforestable")
Nonforestdir <- system.file('extdata/Non-forest/', package = "deforestable")

#### Read the target image ####
tg_dir <- system.file('extdata/', package = "deforestable")
test_image <- read_data_raster('smpl_1.jpeg', dir = tg_dir)


# Simple training of the non-parametric model
Model_nonP_tr <- train(model='fr_Non-Param', Forestdir=Forestdir, Nonforestdir=Nonforestdir,
                       train_method='train', parallel=FALSE)

res <- classify(data=test_image, Model=Model_nonP_tr,
                n_pts=n_pts, parallel=FALSE, progress = 'text')

tmp_d <- tempdir(); tmp_d
jpeg::writeJPEG(image=res, target=paste(tmp_d,'Model_nonP_tr.jpeg', sep='/'))

}
