% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defined.R
\name{as.numeric.haven_labelled_defined}
\alias{as.numeric.haven_labelled_defined}
\alias{as_numeric}
\alias{as_numeric.haven_labelled_defined}
\title{Coerce a defined vector to numeric}
\usage{
\method{as.numeric}{haven_labelled_defined}(x, ...)

as_numeric(x, ...)

\method{as_numeric}{haven_labelled_defined}(x, preserve_attributes = FALSE, ...)
}
\arguments{
\item{x}{A vector created with \code{\link{defined}}.}

\item{...}{Further arguments passed to internal methods (not used).}

\item{preserve_attributes}{Defaults to \code{FALSE}, in which case the
\code{unit}, \code{concept} and \code{namespace} attributes will be
preserved, but the returned value will otherwise become a base R integer,
double or numeric value. If false, then the effect will be similar to
\code{\link{strip_defined}}.}
}
\value{
A numeric vector.
}
\description{
Base R's \code{as.numeric()} does not support custom classes like
\code{defined}. Calling \code{as.numeric()} on a \code{defined} vector will drop all
metadata and class information, which equals to
\code{as_numeric(x, preserve_attributes = FALSE)}.

\code{as_numeric()} is the recommended method to convert a \code{defined}
vector to numeric. It is metadata-aware and ensures that the underlying data
is numeric before coercion.
}
\details{
\code{as_numeric()} allows \code{preserve_attributes = TRUE} when the
resulting vector will retain relevant metadata such as the \code{unit},
\code{concept}, and \code{namespace} attributes, but it will no longer be of class
\code{defined}. If \code{preserve_attributes = FALSE} (default), a plain numeric
vector is returned with all metadata and class dropped.\cr For
character-based \code{defined} vectors, \code{as_numeric()} will throw an informative
error to prevent accidental coercion of non-numeric data.
}
\examples{
as_numeric(orange_df$age, preserve_attributes = TRUE)
gdp <- defined(c(3897L, 7365L), label = "GDP", unit = "million dollars")
gdp_numbers <- as_numeric(gdp)
gdp_numbers
attributes(gdp_numbers)

gdp_striped <- as_numeric(gdp, preserve_attributes = FALSE)
attributes(gdp_striped)
}
\seealso{
\code{\link{as_numeric}}

\code{\link[=strip_defined]{strip_defined()}}
}
