% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabtexdescstat.r
\name{tabtexdescstat}
\alias{tabtexdescstat}
\title{Creates a LaTeX file having a descriptive statistics table
for continuous variables}
\usage{
tabtexdescstat(
  data = data,
  colnames = colnames,
  varnames = varnames,
  cap = cap,
  nametab = nametab,
  save.file = FALSE,
  filename = "tabdescdata.tex",
  eng = TRUE,
  rowlab = "Variable",
  decnum = 3,
  font.size.tab = "normalsize",
  font.type.tab = "normalfont"
)
}
\arguments{
\item{data}{a dataframe containing numeric variables as columns.}

\item{colnames}{a string having the column names of the dataframe
to which the descriptive statistics will be computed.}

\item{varnames}{a string having the name of each of the variables
to be used in the LaTeX table.}

\item{cap}{a string having the caption of the LaTeX table.}

\item{nametab}{a string having a brief name to be used in
both the label of the table and the file name. For instance,
if "=descdata", the table can be refered in your LaTeX
document by using \verb{\\ref\{tab:descdata\}}}

\item{save.file}{The defauls is set to ``FALSE'', if is set to
TRUE, then the option \code{filename} must be provided.}

\item{filename}{A string having the name of the resulting LaTeX
file having the table. The default is set to "tabdescdata.tex".}

\item{eng}{The language to be used in the output. English
is the default, meanwhile if \code{eng}=FALSE, Spanish is used.}

\item{rowlab}{a character with the name to be used as label for
the column where the variables will be printed. The default is
set to "Variables".}

\item{decnum}{the number of decimals to be used in the output. The
default is set to 3.}

\item{font.size.tab}{The defauls is set to "normalsize". You could
also try with "footnotesize".}

\item{font.type.tab}{The defauls is set to "normalfont".}
}
\value{
This function creates a LaTeX file having
the following descriptive statistics: sample size, minimum,
maximum, mean, median, SD, and coefficient of variation.
If the full option is set to TRUE, the following statistics
are added to the table: 25th and 75th percentiles, the
interquartile range, skewness, and kurtosis.
}
\description{
Function to create a LaTeX file for a table of
descriptive statistics of continuous variables from a dataframe.
}
\details{
The resulting file is a LaTeX table, that can be
added to your main LaTeX document by using \verb{\\input\{filename\}}.
}
\examples{

df <- datana::idahohd
head(df)
##example 1
tabtexdescstat(data=df,nametab="idaho",
cap="Descriptive statistics table",
colnames=c("dbh","height"),varnames = c("Diameter","Height"))
##example 2
tabtexdescstat(data=df,nametab="idaho",
cap="Cuadro con estadistica descriptiva",
 colnames=c("dbh","height"),varnames = c("Diametro","Altura"),
 eng=FALSE)
}
\references{
Salas-Eljatib, C. 2021. Análisis de datos con el programa
estadístico R: una introducción aplicada. Ediciones Universidad
Mayor, Santiago, Chile. 170 p. \url{https://eljatib.com/rlibro}
}
\author{
Christian Salas-Eljatib.
}
