% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_margin.R
\name{fit_steplength}
\alias{fit_steplength}
\title{Fit a Linear Univariate Distribution}
\usage{
fit_steplength(
  x,
  parametric = c("beta", "cauchy", "chi-squared", "chisq", "exponential", "exp", "gamma",
    "lognormal", "lnorm", "lognorm", "logistic", "normal", "t", "weibull", "normalmix",
    "weibullmix", "gammamix", "lnormmix", FALSE),
  start = NULL,
  bandwidth = NULL,
  ncomp = 2
)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector} of measurements of a linear
random variable in \eqn{[0,\infty)}.}

\item{parametric}{either a \link[base]{character} string describing what distribution
should be fitted (\code{"beta"}, \code{"cauchy"}, \code{"chi-squared"},
\code{"exponential"}, \code{"gamma"}, \code{"lognormal"}, \code{"logistic"},
\code{"normal"}, \code{"t"}, \code{"weibull"},\code{"normalmix"},
\code{"weibullmix"}, \code{"gammamix"}, or \code{"lnormmix"}),
or the \link[base]{logical}
\code{FALSE} if a non-parametric estimation (kernel density) should be made.}

\item{start}{(optional, except when \code{parametric = "chi-squared"})
named \link[base]{list} containing the parameters to be optimized with initial
values.}

\item{bandwidth}{\link[base]{numeric} value for the kernel density bandwidth.
Default is  \code{cylcop::\link{opt_lin_bw}(x, "nrd")}.}

\item{ncomp}{\link[base]{integer}, number of components of the mixed distribution.
Only has an effect if \code{parametric \%in\% c("normalmix", "weibullmix", "gammamix",
"lnormmix")}.}
}
\value{
If a parametric estimate is made, a \link[base]{list} is returned
containing the estimated parameters, their standard errors,
the log-likelihood, the AIC and the name of the distribution.
If a non-parametric estimate is made, the output is a a '\code{\link[stats]{density}}' object,
which is obtained with the function
\code{GoFKernel::\link[GoFKernel]{density.reflected}()} of the '\pkg{GoFKernel}'
package.
}
\description{
This function finds parameter estimates of the marginal linear
distribution, or gives a kernel density estimate using
a Gaussian smoothing kernel.
}
\examples{
require(graphics)
set.seed(123)

silent_curr <- cylcop_get_option("silent")
cylcop_set_option(silent = TRUE)

n <- 100 #n (number of samples) is set small for performance.

x <- rweibull(n, shape = 10)

dens_non_param <- fit_steplength(x = x, parametric = FALSE)
weibull <- fit_steplength(x = x, parametric = "weibull")
gamma <- fit_steplength(x = x, parametric = "gamma")
chisq <- fit_steplength(x = x, parametric = "chi-squared", start = list(df = 1))

true_dens <- dweibull(seq(0, max(x), length.out = 200),
  shape = 10
)
dens_weibull <- dweibull(seq(0, max(x),length.out = 200),
  shape = weibull$coef$shape,
  scale = weibull$coef$scale
)
dens_gamma <- dgamma(seq(0, max(x),length.out = 200),
  shape = gamma$coef$shape,
  rate = gamma$coef$rate
)
dens_chisq <- dchisq(seq(0, max(x),length.out = 200),
  df = chisq$coef$df
)

plot(seq(0,max(x),length.out = 200), true_dens, type = "l")
lines(dens_non_param$x, dens_non_param$y, col = "red")
lines(seq(0,max(x),length.out = 200), dens_weibull, col = "green")
lines(seq(0,max(x),length.out = 200), dens_gamma, col = "blue")
lines(seq(0,max(x),length.out = 200), dens_chisq, col = "cyan")

cylcop_set_option(silent = silent_curr)

}
\seealso{
\code{GoFKernel::\link[GoFKernel]{density.reflected}()},
\code{\link{fit_angle}()}, \code{\link{opt_lin_bw}()}.
}
