% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticLogNormalSub-class}
\alias{LogisticLogNormalSub-class}
\alias{.LogisticLogNormalSub}
\alias{LogisticLogNormalSub}
\alias{.DefaultLogisticLogNormalSub}
\title{\code{LogisticLogNormalSub}}
\usage{
LogisticLogNormalSub(mean, cov, ref_dose = 0)

.DefaultLogisticLogNormalSub()
}
\arguments{
\item{mean}{(\code{numeric})\cr the prior mean vector.}

\item{cov}{(\code{matrix})\cr the prior covariance matrix. The precision matrix
\code{prec} is internally calculated as an inverse of \code{cov}.}

\item{ref_dose}{(\code{number})\cr the reference dose \eqn{x*}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{LogisticLogNormalSub}} is the class for a standard logistic model with
bivariate (log) normal prior with subtractive dose standardization.
}
\details{
The covariate is the dose \eqn{x} minus the reference dose \eqn{x*},
i.e.:
\deqn{logit[p(x)] = alpha0 + alpha1 * (x - x*),}
where \eqn{p(x)} is the probability of observing a DLT for a given dose \eqn{x}.
The prior \deqn{(alpha0, log(alpha1)) ~ Normal(mean, cov).}
}
\section{Slots}{

\describe{
\item{\code{params}}{(\code{ModelParamsNormal})\cr bivariate normal prior parameters.}

\item{\code{ref_dose}}{(\code{number})\cr the reference dose \eqn{x*}.}
}}

\note{
Typically, end-users will not use the \code{.DefaultLogisticLogNormalSub()} function.
}
\examples{
my_model <- LogisticLogNormalSub(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
  ref_dose = 50
)
}
\seealso{
\code{\link{LogisticNormal}}, \code{\link{LogisticLogNormal}}, \code{\link{ProbitLogNormal}},
\code{\link{ProbitLogNormalRel}}.
}
