crew_test("relay start, terminate, validate", {
  x <- crew_relay()
  expect_silent(x$validate())
  expect_null(x$condition)
  x$start()
  expect_silent(x$validate())
  expect_true(inherits(x$condition, "conditionVariable"))
  expect_true(inherits(x$throttle, "crew_class_throttle"))
  x$terminate()
  expect_silent(x$validate())
  expect_null(x$condition)
})

crew_test("relay and waiting", {
  skip_on_cran() # MKL "Additional issues" on CRAN
  x <- crew_relay()
  cv_from <- nanonext::cv()
  cv_to <- nanonext::cv()
  x$set_from(cv_from)
  x$set_to(cv_to)
  x$start()
  expect_silent(x$validate())
  nanonext::cv_signal(x$from)
  nanonext::msleep(1000)
  expect_equal(nanonext::cv_value(x$from), 1L)
  expect_equal(nanonext::cv_value(x$condition), 1L)
  expect_equal(nanonext::cv_value(x$to), 1L) # was 0 on MKL
  expect_true(x$wait())
  expect_equal(nanonext::cv_value(x$from), 1L)
  expect_equal(nanonext::cv_value(x$condition), 0L)
  expect_equal(nanonext::cv_value(x$to), 1L)
  expect_false(x$wait())
  expect_equal(nanonext::cv_value(x$from), 1L)
  expect_equal(nanonext::cv_value(x$condition), 0L)
  expect_equal(nanonext::cv_value(x$to), 1L)
})
