% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_same_col.R
\name{find_same_col}
\alias{find_same_col}
\title{Find column with same non-positive values}
\usage{
find_same_col(invmatrix)
}
\arguments{
\item{invmatrix}{Inverse of the hypothesis matrix}
}
\value{
Integer index of the reference level, if there is
no reference level, NA is returned
}
\description{
The inverse matrix of a contrast matrix has a useful property
where, after removing the row corresponding to the intercept,
the reference level is the column index where each value in
that column is (1) the same and (2) less than or equal to 0.
}
\details{
For a contrast matrix generated from an expression \code{x}, with
number of levels n, consider the inverse matrices from
\code{solve(.contrasts_to_hypotheses(x))} below for different \code{x}:
\itemize{
\item contr.treatment: The first column contains all 0s, hence
the reference level is the first level
\item contr.SAS: The last column contains all 0s, hence the
reference level is the last level
\item scaled_sum_code: The first column contains all -1/n, hence
the reference level is the first level
\item helmert_code: While the first column contains all negative
numbers, they are not the same EXCEPT if n=2
}

Note that "reference level" here is defined as a level from
which every other level is compared to via pairwise comparisons.
}
\keyword{internal}
