% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_inference.R
\name{get_hierarchical_clusters}
\alias{get_hierarchical_clusters}
\title{Perform modularity-based hierarchical clustering for a correlation matrix}
\usage{
get_hierarchical_clusters(cormat, min_cluster_corr = 0.8)
}
\arguments{
\item{cormat}{A correlation matrix.}

\item{min_cluster_corr}{The small correlation for the weights distributions across different iterations to be decided having only one cluster. Default is 0.8.}
}
\value{
A list containing:
\item{cluster}{A binary matrix indicating the cluster membership of each variable.}
\item{Q_modularity}{The modularity values for the identified clusters.}
}
\description{
This function performs a modularity-based hierarchical clustering approach to identify clusters from a correlation matrix.
}
\examples{
# Example usage
set.seed(1)
N <- 100
P <- 4
sigma <- matrix(0.2, nrow = P, ncol = P)
diag(sigma) <- 1
sigma[1:2, 1:2] <- 0.9
sigma[3:4, 3:4] <- 0.9
X <- MASS::mvrnorm(N, rep(0, P), sigma)
cormat <- get_cormat(X)
clusters <- get_hierarchical_clusters(cormat)
clusters$cluster
clusters$Q_modularity

}
\seealso{
Other colocboost_utilities: 
\code{\link{get_cormat}()},
\code{\link{get_cos}()},
\code{\link{get_cos_purity}()},
\code{\link{get_cos_summary}()},
\code{\link{get_ucos_summary}()}
}
\concept{colocboost_utilities}
\keyword{cb_post_inference}
