% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{cnd_exports}
\alias{cnd_exports}
\title{Add conditions to functions}
\usage{
cnd_exports(env = parent.frame())
}
\arguments{
\item{env}{The package environment}
}
\value{
Nothing, called for its side-effects
}
\description{
\verb{[cnd_exports()]} should be used within a package's building
environment.
}
\examples{
e <- new.env()
registry <- cnd_create_registry("EXAMPLE", env = e)
local(envir = e, {
  my_fun <- function() NULL
  condition(
    "my_condition",
    package = "example_package",
    exports = "my_fun",
    registry = registry
  )
  cnd_exports()
})

# conditions are now added to my_fun():
e$my_fun
conditions(e$my_fun)
}
