% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{clmstan-package}
\alias{clmstan}
\alias{clmstan-package}
\title{clmstan: Cumulative Link Models with CmdStanR}
\description{
Fit cumulative link models (CLMs) for ordinal categorical data using
CmdStanR. The package supports various link functions including standard
links (logit, probit, cloglog, loglog, cauchit) and flexible parametric
links (GEV, AEP, Symmetric Power, Aranda-Ordaz, log-gamma).

Models are pre-compiled using the instantiate package for fast execution
without runtime compilation.
}
\section{Main functions}{

\itemize{
\item \code{\link[=clm_stan]{clm_stan()}} - Fit a cumulative link model
\item \code{\link[=supported_links]{supported_links()}} - List available link functions
}
}

\section{Methods}{

\itemize{
\item \code{\link[=print.clmstan]{print.clmstan()}} - Print summary
\item \code{\link[=summary.clmstan]{summary.clmstan()}} - Detailed summary
\item \code{\link[=coef.clmstan]{coef.clmstan()}} - Extract coefficients
\item \code{\link[=predict.clmstan]{predict.clmstan()}} - Predict categories or probabilities
\item \code{\link[=plot.clmstan]{plot.clmstan()}} - Diagnostic plots
\item \code{\link[=loo.clmstan]{loo.clmstan()}} - Leave-one-out cross-validation
}
}

\references{
\strong{Flexible Link Functions:}

Aranda-Ordaz, F. J. (1981). On two families of transformations to additivity
for binary response data. \emph{Biometrika}, 68(2), 357-363.

Li, D., Wang, X., & Dey, D. K. (2019). Power link functions in an ordinal
regression model with Gaussian process priors. \emph{Environmetrics}, 30(6), e2564.

Prentice, R. L. (1976). A generalization of the probit and logit methods
for dose response curves. \emph{Biometrics}, 32(4), 761-768.

Wang, X. & Dey, D. K. (2011). Generalized extreme value regression for
ordinal response data. \emph{Environmental and Ecological Statistics}, 18(4), 619-634.

Naranjo, L., Pérez, C. J., & Martín, J. (2015). Bayesian analysis of some
models that use the asymmetric exponential power distribution.
\emph{Statistics and Computing}, 25(3), 497-514.
}
\seealso{
Useful links:
\itemize{
\item \href{https://wlandau.github.io/instantiate/}{instantiate package}
\item \href{https://mc-stan.org/cmdstanr/}{cmdstanr}
}
}
\author{
\strong{Maintainer}: Tomotaka Momozaki \email{momozaki.stat@gmail.com}

}
\keyword{internal}
