% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{cauchy}
\alias{cauchy}
\title{Cauchy Distribution for Prior Specification}
\usage{
cauchy(mu = 0, sigma = 1)
}
\arguments{
\item{mu}{Location parameter. Default: 0}

\item{sigma}{Scale parameter. Must be positive. Default: 1}
}
\value{
An object of class \code{"clm_dist"} representing a Cauchy distribution.
}
\description{
Creates a Cauchy distribution object for use with \code{\link[=prior]{prior()}}.
}
\examples{
# Create a Cauchy prior (weakly informative)
cauchy(0, 2.5)

# Use with prior()
prior(cauchy(0, 2.5), class = "b")
}
\seealso{
\code{\link[=prior]{prior()}}, \code{\link[=normal]{normal()}}, \code{\link[=gamma]{gamma()}}, \code{\link[=student_t]{student_t()}}
}
