% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA_DML.R
\name{AAA_DML}
\alias{AAA_DML}
\title{Average Adjusted Association}
\usage{
AAA_DML(y, t, x, type = "pro", k = 10)
}
\arguments{
\item{y}{n-dimensional vector of binary outcomes}

\item{t}{n-dimensional vector of binary treatments}

\item{x}{n by d matrix of covariates}

\item{type}{'pro' if the average is based on prospective regression;
'retro' if it is based on prospective regression (default = 'pro')}

\item{k}{number of folds in k-fold partition (default = 10)}
}
\value{
An S3 object of type "ciccr". The object has the following elements.
\item{est}{a scalar estimate}
\item{se}{standard error}
}
\description{
Averages the log odds ratio using prospective or retrospective high-dimensional logistic regression
}
\examples{
# use the ACS dataset included in the package
  y = ciccr::ACS$topincome
  t = ciccr::ACS$baplus
  age = ciccr::ACS$age
  x = splines::bs(age, df=6) # b-splines for age

  results = AAA_DML(y, t, x, 'pro', k=2)

}
\references{
Jun, S.J. and Lee, S. (2020). Causal Inference under Outcome-Based Sampling with Monotonicity Assumptions.
\url{https://arxiv.org/abs/2004.08318}.
}
