% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists.R
\name{list_lengths}
\alias{list_lengths}
\alias{lengths_}
\alias{unlisted_length}
\alias{new_list}
\alias{list_assign}
\alias{list_modify}
\alias{list_combine}
\alias{list_drop_null}
\title{List utilities}
\usage{
list_lengths(x, names = FALSE)

lengths_(x, names = FALSE)

unlisted_length(x)

new_list(length = 0L, default = NULL)

list_assign(x, values)

list_modify(x, values)

list_combine(..., .args = NULL)

list_drop_null(x)
}
\arguments{
\item{x}{A list.}

\item{names}{Should names of list elements be added? Default is \code{FALSE}.}

\item{length}{Length of list.}

\item{default}{Default value for each list element.}

\item{values}{A named list}

\item{...}{Objects to combine into a list.}

\item{.args}{An alternative to \code{...} so you can supply arguments directly
in a list. \cr
This is equivalent to \code{do.call(f, .args)} but much more efficient.}
}
\value{
\code{list_lengths()} returns the list lengths. \cr
\code{unlisted_length()} is a fast alternative to \code{length(unlist(x))}. \cr
\code{new_list()} is like \code{vector("list", length)} but also allows you to specify
a default value for each list element. This can be useful for
initialising with a catch-all value so that when you unlist you're guaranteed
a list of length >= to the specified length.

\code{list_assign()} is vectorised version of \verb{[[<-} that
concatenates \code{values} to \code{x} or modifies \code{x} where the
names match. Can be useful for modifying data frame variables.

\code{list_combine()} combines each element of a set of lists into a single list.
If an element is not a list, it is treated as a length-one list.
This happens to be very useful for combining data frame cols.

\code{list_drop_null()} removes \code{NULL} list elements very quickly.
}
\description{
Functions to help work with lists.
}
\examples{
library(cheapr)
l <- list(1:10,
          NULL,
          list(integer(), NA_integer_, 2:10))

lengths_(l) # Faster lengths()
unlisted_length(l) # length of vector if we unlist
paste0("length: ", length(print(unlist(l))))

unlisted_length(l) - na_count(l) # Number of non-NA elements

# We can create and initialise a new list with a default value
l <- new_list(20, 0L)
l[1:5]
# This works well with vctrs_list_of objects

}
