% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{generate_ratings}
\alias{generate_ratings}
\title{Generate Ratings for a Stimulus Using LLM APIs}
\usage{
generate_ratings(
  model = "gpt-3.5-turbo",
  stim = "kick the bucket",
  prompt = "You are a native English speaker.",
  question = "Please rate the following stim:",
  top_p = 1,
  temp = 0,
  n_iterations = 30,
  api_key = "",
  debug = FALSE
)
}
\arguments{
\item{model}{A character string specifying the LLM model (e.g., "gpt-3.5-turbo", "deepseek-chat").}

\item{stim}{A character string representing the stimulus (e.g., an idiom).}

\item{prompt}{A character string for the system prompt (e.g., "You are a native English speaker.").}

\item{question}{A character string for the user prompt (e.g., "Please rate the following stim:").}

\item{top_p}{Numeric value for the probability mass (default 1).}

\item{temp}{Numeric value for the temperature (default 0).}

\item{n_iterations}{An integer indicating how many times to query the API.}

\item{api_key}{API key as a character string.}

\item{debug}{Logical; if TRUE, debug information is printed.}
}
\value{
A data frame containing the stimulus, the rating, and the iteration number.
}
\description{
Generates ratings for a given stimulus by calling one of several LLM APIs.
}
\details{
This function supports multiple APIs. Branching is based on the \code{model} parameter.
}
\examples{
\dontrun{
  ratings <- generate_ratings(
    model = "gpt-3.5-turbo",
    stim = "kick the bucket",
    prompt = "You are a native English speaker.",
    question = "Please rate the following stim:",
    n_iterations = 5,
    api_key = "your_api_key"
  )
  print(ratings)
}
}
