% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_option_chains.R
\name{get_option_chains}
\alias{get_option_chains}
\title{Get Option Chains}
\usage{
get_option_chains(
  tokens,
  symbol,
  contract_type = NULL,
  strike_count = NULL,
  include_underlying_quote = NULL,
  strategy = NULL,
  interval = NULL,
  strike = NULL,
  range = NULL,
  from_date = NULL,
  to_date = NULL,
  volatility = NULL,
  underlying_price = NULL,
  interest_rate = NULL,
  days_to_expiration = NULL,
  exp_month = NULL,
  option_type = NULL,
  entitlement = NULL
)
}
\arguments{
\item{tokens}{token object from `get_authentication_tokens` function (list).}

\item{symbol}{symbol of interest (string).}

\item{contract_type}{string containing "ALL", "PUT", or "CALL". Default is NULL, which is "ALL" (string).}

\item{strike_count}{number of strikes to return above or below the at-the-monty price (numeric). Default is NULL, which will return all.}

\item{include_underlying_quote}{flag to indicate whether underlying quotes to be included. Default is NULL, which is TRUE (boolean).}

\item{strategy}{type of strategy to return, can be "SINGLE", "ANALYTICAL", "COVERED", "VERTICAL", "CALENDAR", "STRANGLE", "STRADDLE", "BUTTERFLY", "CONDOR", "DIAGONAL", "COLLAR", or "ROLL". Default is NULL, which is "SINGLE" (string).}

\item{interval}{strike interval for the spread strategy chains (see strategy parameter). Default is NULL (numeric).}

\item{strike}{strike price - default is NULL (which will not return a specific strike price) (numeric).}

\item{range}{range (ITM, NTM, OTM, etc.). Default is NULL, which will return all (string).}

\item{from_date}{from date - default is NULL, which will return all (date).}

\item{to_date}{to date - default is NULL, which will return all (date).}

\item{volatility}{volatility to use in calculation and only applies to ANALYTICAL strategy (see strategy parameter). Default is NULL. (numeric).}

\item{underlying_price}{underlying price to use in calculation and only applies to ANALYTICAL strategy (see strategy parameter). Default is NULL (numeric).}

\item{interest_rate}{interest rate to use in calculation and only applies to ANALYTICAL strategy (see strategy parameter). Default is NULL (numeric).}

\item{days_to_expiration}{days to expiration to use in calculation and only applies to ANALYTICAL strategy (see strategy parameter). Default is NULL (numeric).}

\item{exp_month}{expiration month - valid values are "ALL", "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", or "DEC". Default is NULL, which is "ALL" (string).}

\item{option_type}{option type - default is NULL, which will return everything (string).}

\item{entitlement}{applicable only for retail token, entitlement of client PP-PayingPro, NP-NonPro, and PN-NonPayingPro. Valid values are "PN", "NP", "PP" - default is NULL, which will return everything (string).}
}
\value{
Returns a data frame containing information about the
        given symbol's option chain.
}
\description{
Given the tokens object from the `get_authentication_tokens`
function and the symbol of interest, return a data frame
containing information about the option chain. Note that there
are many ways to customize the data returned, including being
able to specify the strategy as analytical and providing custom
input assumptions. Refer to the parameters below for more
detailed information.
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, June 2024
}
\keyword{chains}
\keyword{option}
