% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scurve.R
\name{gen_scurvehole}
\alias{gen_scurvehole}
\title{Generate S-curve Data with a Hole}
\usage{
gen_scurvehole(n = 500, p = 4, noise_fun = gen_noisedims, ...)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{noise_fun}{A function specifying which noise generation function to use for the additional dimensions. Default is \code{gen_noisedims}. Other options include \code{gen_wavydims1}, \code{gen_wavydims2}, and \code{gen_wavydims3}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun} (e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing the generated S-curve data with a hole.
}
\description{
This function generates S-curve data with a hole by filtering out samples that
are not close to a specified anchor point.
}
\examples{
set.seed(20240412)
scurvehole <- gen_scurvehole(n = 500, p = 4)
}
\references{
Wang, Y., Huang, H., Rudin, C., & Shaposhnik, Y. (2021).
Understanding how dimension reduction tools work: an empirical approach to
deciphering t-SNE, UMAP, TriMAP, and PaCMAP for data visualization.
\emph{J Mach. Learn. Res}, \emph{22}, 1-73.
}
\seealso{
the \href{https://github.com/YingfanWang/PaCMAP}{PaCMAP homepage}.
}
