% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_curve.R
\name{mirror_scurves}
\alias{mirror_scurves}
\title{Generate Mirror S-curve Datasets with Noise}
\usage{
mirror_scurves(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate (should be divisible by 2).}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the combined mirror S-curve datasets with added noise.
}
\description{
This function generates mirror S-curve datasets with added noise dimensions.
}
\examples{
set.seed(20240412)
mirror_s_curve_data <- mirror_scurves(
  n = 200, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
