% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflect.R
\name{reflect}
\alias{reflect}
\alias{reflect.data.frame}
\alias{reflect.cancor}
\alias{reflect.candisc}
\title{Reflect Columns in an Object, reversing the sign of all elements}
\usage{
reflect(object, columns = 1:2, ...)

\method{reflect}{data.frame}(object, columns = 1:2, ...)

\method{reflect}{cancor}(object, columns = 1:2, ...)

\method{reflect}{candisc}(object, columns = 1:2, ...)
}
\arguments{
\item{object}{An object whose columns are to be reflected}

\item{columns}{a vector of indices of the columns to reflect}

\item{...}{Unused}
}
\value{
The object with specified columns of the variable coefficients and observation scores multiplied by -1.
}
\description{
\code{candisc} and \code{cancor}  objects have coefficients for the X and Y and weighted scores for these,
whose signs are arbitrary, in the sense that a given column can be reflected (multiplied by -1) without changing the fit.
But, often you will want to reverse the direction of one or more dimensions for ease of interpretation.

This function allows you to reflect any columns of the variable coefficients (and corresponding observation scores).
This is often useful for interpreting a biplot, for example when a component (often the first) has all negative signs.
}
\details{
\code{reflect} methods are available for:
\itemize{
\item \code{data.frame}s
\item \code{"cancor"} objects
\item \code{"candisc"} objects
}

Note that \code{\link[=plot.candisc]{plot.candisc()}} and \code{\link[=plot.candisc]{plot.candisc()}} can handle this internally using the argument \code{rev.axes}.
}
\section{Methods (by class)}{
\itemize{
\item \code{reflect(data.frame)}: \code{"data.frame"} method.

\item \code{reflect(cancor)}: \code{"cancor"} method.

\item \code{reflect(candisc)}: \code{"candisc"} method.

}}
\seealso{
\link[ggbiplot:reflect]{ggbiplot::reflect} has similar methods for PCA-like objects
}
\author{
Michael Friendly
}
