% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_parking_lorry_details}
\alias{autobahn_parking_lorry_details}
\title{Get Autobahn lorry parking details}
\usage{
autobahn_parking_lorry_details(
  lorry_id,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{lorry_id}{Lorry parking identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with lorry parking details.
}
\description{
Get Autobahn lorry parking details
}
\details{
Returns full details for a single lorry parking entry.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
parking <- autobahn_parking_lorries(roads$road_id[[1]])
autobahn_parking_lorry_details(parking$identifier[[1]])
}
}
\seealso{
\code{\link[=autobahn_parking_lorries]{autobahn_parking_lorries()}} to list parking areas.
}
