% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p.R
\name{processBullets}
\alias{processBullets}
\title{Process x3p file}
\usage{
processBullets(bullet, name = "", x = 100, grooves = NULL, span = 0.75,
  window = 0, ...)
}
\arguments{
\item{bullet}{file as returned from read_x3p}

\item{name}{name of the bullet}

\item{x}{(vector) of surface crosscuts to process.}

\item{grooves}{The grooves to use as a two element vector, if desired}

\item{span}{The span for the loess fit}

\item{window}{The mean window around the ideal crosscut}

\item{...}{Additional arguments, passed to the get_grooves function}
}
\value{
data frame
}
\description{
x3p file of a 3d topological bullet surface is processed at surface crosscut x, 
the bullet grooves in the crosscuts are identified and removed, and a loess smooth 
is used (see \code{?loess} for details) to remove the big structure.
}
\examples{
data(br411)
br411_processed <- processBullets(br411, name = "br411")
}
