% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternFuns.R
\name{rescale_matrix}
\alias{rescale_matrix}
\title{Rescale a matrix}
\usage{
rescale_matrix(
  mat,
  type = c("Expression", "Log2 Expression", "Mean Scaled", "Z-score")
)
}
\arguments{
\item{mat}{the matrix to rescale}

\item{type}{type of rescaling; one of "Expression" (defautl, does nothing),
"Log2 Expression" (returns log2(x + 1) for every value), "Mean Scaled" (each
row is scaled by its average), "Z-score" (each row is centered and scaled
to mean = 0 and sd = 1)}
}
\value{
The rescaled matrix.
}
\description{
This function rescales the rows of a matrix according to the
specified type.
}
\examples{
mat = matrix(1:10, nrow = 2, ncol = 5)
rescale_matrix(mat, type = "Expression")
rescale_matrix(mat, type = "Log2 Expression")
rescale_matrix(mat, type = "Mean Scaled")
rescale_matrix(mat, type = "Z-score")
}
