% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_box_use.R
\name{style_box_use_file}
\alias{style_box_use_file}
\title{Style the box::use() calls of a source code}
\usage{
style_box_use_file(filename, indent_spaces = 2, trailing_commas_func = FALSE)
}
\arguments{
\item{filename}{A file path to style.}

\item{indent_spaces}{An integer scalar indicating tab width in units of spaces}

\item{trailing_commas_func}{A boolean to activate adding a trailing comma to the end of the lists
of functions to attach.}
}
\description{
Style the box::use() calls of a source code
}
\details{
Refer to \code{\link[=style_box_use_text]{style_box_use_text()}} for styling details.
}
\examples{
code <- "box::use(stringr[str_trim, str_pad], dplyr)"
file <- tempfile("style", fileext = ".R")
writeLines(code, file)

style_box_use_file(file)

}
